/*
 * MonitorServerThread.java
 *
 * 
 */
 package	DisCSP.DistributedCSP;

import java.io.*;
import java.net.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


class MonitorServerThread extends Thread
{

	private Socket socket;
	private BufferedReader in;
	private PrintWriter out;
	private AgentDescriptor[] agents;
	private MonitorState state;
	private PrintStream prtStr;
	
 	/** Costruttore di MonitorServerThread
     * 
     * @param s la socket
     * @param ag i descrittori degli agenti
     * @param st lo stato del Monitor
     * @param ps il PrintStream su cui direzionare l'output
     * 
     */	

	public MonitorServerThread(Socket s,AgentDescriptor[] ag,MonitorState st,PrintStream ps) throws IOException
	{
		prtStr=ps;
		agents=ag;
		state=st;
		socket = s;
		in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
		out = new PrintWriter(new BufferedWriter(osw), true);
		start(); 
	}
	 
	 /** Metodo run del Thread
     * 
     * 
     */	
	public void run()
	{
		synchronized (state)
		{
			try
			{
	    	   	String str=null;
	    	   	while (str==null)
	    		{
	    			 str = in.readLine();
	    		}
	    		
				String[] mess=str.split(" ");
				socket.close();
				if(mess[0].equals("arc_last_connection")||state.consistent() ) return;
				if(mess[0].equals("arc_no_solution"))
				{
					state.setConsistent(true);
					lastConnection();
					return;
				}	
				
				String currentAddr=mess[1];
				int currentPort=new Integer(mess[2]).intValue();
	
				prtStr.println("Monitor: received "+mess[0]+" from IP: "+mess[1]+" Port: "+mess[2]);
				if(mess[0].equals("arc_first_waiting"))
				{
					
					int init=new Integer(mess[3]).intValue();
					for(int i=0;i<agents.length;i++)
					{
						if(currentAddr.equals(agents[i].addressString()) && currentPort==agents[i].port())
						{
							agents[i].setCurrentInitiative(init);
							break;
						}
					}
					
				}
				
				else
				{
					String initAddr=mess[3];
					int initPort=new Integer(mess[4]).intValue();
					int init=new Integer(mess[5]).intValue();
					boolean stop=false;
					for(int i=0;i<agents.length;i++)
					{
						if(initAddr.equals(agents[i].addressString()) && initPort==agents[i].port())
						{
							agents[i].setState(init,mess[0]);
							stop=agents[i].test();
							break;
						}
					}
					if(stop&&!state.consistent())
					{
						for(int i=0;i<agents.length;i++)
						{
							sendConsistency(agents[i].address(), agents[i].port());
						}
						
						state.setConsistent(true);
						lastConnection();					
					}
				}						
			}	
			catch (IOException e)
			{
			}
		
		}
		
	}
	
	private void sendConsistency(InetAddress addr, int p)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
			
			
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_consistency");
			
			prtStr.println("Monitor: sent arc_consistency");
				
			socket.close();			
			
		}

	    catch(Exception e)
	    {
	    }    	    
	}
	
	private void lastConnection()
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(state.address(), state.port());
			
			
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_last_connection");
							
			socket.close();
										
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}


		
}